---
title: SwiftLint
theme: solarized
revealOptions:
    transition: 'slide'
---

# SwiftLint

---

## Why SwiftLint?
* Intra-Project/Inter-Project Consistency
* Readability
* Better Code Quality

---

## Installation
* Homebrew: `brew install swiftlint`
* Cocoapods: `pod 'SwiftLint'`(Slow...)
* Xcode Plugin: [SwiftLintXcode](https://github.com/ypresto/SwiftLintXcode)

---

## Integration 
Add a new "Run Script Phase"
```
if which swiftlint >/dev/null; then
  swiftlint
else
  echo "warning: SwiftLint not installed, download from https://github.com/realm/SwiftLint"
fi
```
Or
```
"${PODS_ROOT}/SwiftLint/swiftlint"
```

---

## Rule Types
* Stylistic Rules
* Hygienic Rules
* Convention Rules
* Code Smells Rules
* Bug Avoiding Rules

---

## Custom Rule
Define custom regex-based rules:

```
custom_rules:
  no_default_header_comment: # rule identifier
    included: ".*\\.swift" # regex that defines paths to include during linting. optional.
    name: "No Default Header Comment" # rule name. optional.
    regex: "//\n//.+\n//.+\n//\n//.+\n//  Copyright.+$\n//\n\n" # matching pattern
    match_kinds: # SyntaxKinds to match. optional.
      - comment
    message: "Remove Default Header Comment" # violation message. optional.
    severity: warning # violation severity. optional.
```

---

## Disable rules
### Code block
```
// swiftlint:disable colon
let noWarning :String = ""
// swiftlint:enable colon

let hasWarning :String = ""
```

---

### Code line
* `// swiftlint:disable:this (rule name)`
* `// swiftlint:disable:next (rule name)`
* `// swiftlint:disable:previous (rule name)`

---

For example:
```
// swiftlint:disable:next force_cast
let noWarning0 = NSNumber() as! Int
let hasWarning1 = NSNumber() as! Int
let noWarning2 = NSNumber() as! Int // swiftlint:disable:this force_cast
let noWarning3 = NSNumber() as! Int
// swiftlint:disable:previous force_cast
```


